<?php

// app/Http/Controllers/CourseCategoryController.php

namespace App\Http\Controllers;

use App\Models\CourseCategory;
use Illuminate\Http\Request;

class CourseCategoryController extends Controller
{
    // Display all categories
    public function index()
    {
        $categories = CourseCategory::all();
        return view('backend.course_categories.index', compact('categories'));
    }

    // Show the form to create a new category
    public function create()
    {
        return view('backend.course_categories.create');
    }

    // Store a new category
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:course_categories,name',
        ]);

        CourseCategory::create([
            'name' => $request->name,
        ]);

        return redirect()->route('backend.course_categories.index')
                         ->with('success', 'Category created successfully.');
    }

    // Show the form to edit a category
    public function edit(CourseCategory $category)
    {
        return view('backend.course_categories.edit', compact('category'));
    }

    // Update an existing category
    public function update(Request $request, CourseCategory $category)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:course_categories,name,' . $category->id,
        ]);

        $category->update([
            'name' => $request->name,
        ]);

        return redirect()->route('backend.course_categories.index')
                         ->with('success', 'Category updated successfully.');
    }

    // Delete a category
    public function destroy(CourseCategory $category)
    {
        $category->delete();
        return back()->with('success', 'Category deleted successfully.');
    }
}
