<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ErpLink;

class ErpLinkController extends Controller
{
    public function index()
    {
        $links = ErpLink::all();
        return view('backend.erp-links.index', compact('links'));
    }

    public function create()
    {
        return view('backend.erp-links.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required',
            'label' => 'required',
            'url' => 'required|url',
            'status' => 'required|boolean',
        ]);

        ErpLink::create($request->all());
        return redirect()->route('backend.erp-links.index')->with('success', 'ERP Link created successfully.');
    }

    public function edit($id)
    {
        $link = ErpLink::findOrFail($id);
        return view('backend.erp-links.edit', compact('link'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'type' => 'required',
            'label' => 'required',
            'url' => 'required|url',
            'status' => 'required|boolean',
        ]);

        $link = ErpLink::findOrFail($id);
        $link->update($request->all());

        return redirect()->route('backend.erp-links.index')->with('success', 'ERP Link updated successfully.');
    }

    public function destroy($id)
    {
        $link = ErpLink::findOrFail($id);
        $link->delete();

        return redirect()->route('backend.erp-links.index')->with('success', 'ERP Link deleted successfully.');
    }
}