<?php

namespace App\Http\Controllers;

use App\Models\Facilitie;
use Illuminate\Http\Request;

class FacilitieController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $facilities=Facilitie::latest()->paginate(10);
        return view('backend.facilities.index',compact('facilities'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.facilities.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'title'=>'nullable|string',
            'description' =>'nullable|string',
            'image'=>'nullable|image|mimes:jpg,png,jpeg,gif',
        ]);

        $imagePath = null;
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $extension = $image->getClientOriginalExtension();
        $imageName = time() . '.' . $extension;
        $image->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName;
    }
        Facilitie::create([
            'title'=>$request->title,
        'description'=>$request->description,
        'image' => $imagePath,
        'status' => $request->status ? 1 : 0,
        ]);

        return redirect()->route('backend.facilities.index')->with('success', 'School Facilities created successfully.');

    }

    /**
     * Display the specified resource.
     */
    public function show(Facilitie $facilitie)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Facilitie $facilitie)
    {
        return view('backend.facilities.edit',compact('facilitie'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Facilitie $facilitie)
    {
        $request->validate([
            'title'=>'nullable|string',
            'description' =>'nullable|string',
            'image'=>'nullable|image|mimes:jpg,png,jpeg,gif',
        ]);

        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($facilitie->image && file_exists(public_path($facilitie->image))) {
                unlink(public_path($facilitie->image));
            }

            // Upload new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $facilitie->image = 'admin/img/' . $imageName; // Save relative path
        }
        $facilitie->update([
            'title'=>$request->title,
        'description'=>$request->description,
        'status' => $request->status ? 1 : 0,
        ]);

        return redirect()->route('backend.facilities.index')->with('success', 'School Facilities updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Facilitie $facilitie)
    {
        if ($facilitie->image && file_exists(public_path($facilitie->image))) {
            unlink(public_path($facilitie->image));
        }

        $facilitie->delete();
        return redirect()->route('backend.facilities.index')->with('success', 'Facilitie deleted successfully.');
    }
}
