<?php

namespace App\Http\Controllers;

use App\Models\Menu;
use App\Models\MenuContent;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class MenuContentController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($id)
    {
        $menu = Menu::findOrFail($id);
        $menucontents = MenuContent::where('menu_id', $id)->latest()->paginate(10);
        return view('backend.menucontents.index', compact('menu', 'menucontents'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create($id)
    {
          // Fetch the specific menu by its ID
    $menu = Menu::find($id);

    if (!$menu) {
        // Handle the case where the menu does not exist
        return redirect()->back()->with('error', 'Menu not found.');
    }

        return view('backend.menucontents.create', compact('id','menu'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, $id)
    {
        $request->validate([
            'title' => 'nullable|string',
            'heading' => 'nullable|string',
            'description' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif',
        ]);

        $imagePath = null;
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $imagePath = 'admin/img/' . $imageName;
        }

        MenuContent::create([
            'menu_id' => $id,
            'title' => $request->title,
            'sluk' => Str::slug($request->title),
            'heading' => $request->heading,
            'description' => $request->description,
            'image' => $imagePath,
            'status' => $request->status ? 1 : 0,
        ]);

        return redirect()->route('backend.menucontents.index', ['id' => $id])
                         ->with('success', 'Menu Content created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id, MenuContent $menucontent)
    {
        return view('backend.menucontents.edit', compact('id', 'menucontent'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id, MenuContent $menucontent)
    {
        $request->validate([
            'title' => 'nullable|string',
            'heading' => 'nullable|string',
            'description' => 'nullable|string',
            'metatitle' => 'nullable|string',
            'keywords' => 'nullable|string',
            'url' => 'nullable|url',
            'status' => 'nullable|boolean',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif',
        ]);

        if ($request->hasFile('image')) {
            if ($menucontent->image && file_exists(public_path($menucontent->image))) {
                unlink(public_path($menucontent->image));
            }

            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $menucontent->image = 'admin/img/' . $imageName;
        }

        $menucontent->update([
            'menu_id' => $id,
            'title' => $request->title,
            'sluk' => Str::slug($request->title),
            'heading' => $request->heading,
            'url' => $request->url,
            'metatitle' => $request->metatitle,
            'description' => $request->description,
            'keywords' => $request->keywords,
            'status' => $request->status ? 1 : 0,
            'image' => $menucontent->image ?? $menucontent->getOriginal('image'),
        ]);

        return redirect()->route('backend.menucontents.index', ['id' => $id])
                         ->with('success', 'Menu Content updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id, MenuContent $menucontent)
    {
        if ($menucontent->image && file_exists(public_path($menucontent->image))) {
            unlink(public_path($menucontent->image));
        }

        $menucontent->delete();

        return redirect()->route('backend.menucontents.index', ['id' => $id])
                         ->with('success', 'Menu Content deleted successfully.');
    }
}
