<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\NoticeCategory;
use Illuminate\Support\Str; // ✅ Required for slug generation

class NoticeCategoryController extends Controller
{
    public function index()
    {
        $categories = NoticeCategory::latest()->get();
        return view('backend.notice-categories.index', compact('categories'));
    }

    public function create()
    {
        return view('backend.notice-categories.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:notice_categories,name',
        ]);

        NoticeCategory::create([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
        ]);

        return redirect()->route('backend.notice-categories.index')->with('success', 'Notice category created successfully.');
    }

    public function edit($id)
    {
        $category = NoticeCategory::findOrFail($id);
        return view('backend.notice-categories.edit', compact('category'));
    }

    public function update(Request $request, $id)
    {
        $category = NoticeCategory::findOrFail($id);

        $request->validate([
            'name' => 'required|string|max:255|unique:notice_categories,name,' . $id,
        ]);

        $category->update([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
        ]);

        return redirect()->route('backend.notice-categories.index')->with('success', 'Notice category updated successfully.');
    }

    public function destroy($id)
    {
        $category = NoticeCategory::findOrFail($id);
        $category->delete();

        return redirect()->route('backend.notice-categories.index')->with('success', 'Notice category deleted successfully.');
    }
}
