<?php

namespace App\Http\Controllers;

use App\Models\PopularClass;
use App\Models\Standard;
use Illuminate\Http\Request;

class PopularClassController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $populars=PopularClass::latest()->paginate(10);
        return view('backend.popularClasses.index',compact('populars'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $standards = Standard::all();
        return view('backend.popularClasses.create',compact('standards'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'class' => 'required|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            'name' => 'nullable|string',
            'rank' => 'nullable|string'
        ]);

        $imagePath = null;
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $extension = $image->getClientOriginalExtension();
        $imageName = time() . '.' . $extension;
        $image->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName;
    }


    PopularClass::create([
        'image' => $imagePath,
        'class' => $request->class,
        'name' => $request->name,
        'rank' => $request->rank,
        'status' => $request->status ? 1 : 0,
    ]);

    return redirect()->route('backend.popularClasses.index')->with('success', 'Popular Classes created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(PopularClass $popularClass)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(PopularClass $popularClass)
    {
        return view('backend.popularClasses.edit',compact('popularClass'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PopularClass $popularClass)
    {
        $request->validate([
            'class' => 'required|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            'name' => 'nullable|string',
            'rank' => 'nullable|string'
        ]);

        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($popularClass->image && file_exists(public_path($popularClass->image))) {
                unlink(public_path($popularClass->image));
            }

            // Upload new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $popularClass->image = 'admin/img/' . $imageName; // Save relative path
        }

        $popularClass->update([
             'class' => $request->class,
        'name' => $request->name,
        'rank' => $request->rank,
            'status' => $request->status ? 1 : 0,
        ]);

        return redirect()->route('backend.popularClasses.index')->with('success', 'Popular Classes updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PopularClass $popularClass)
    {
        if ($popularClass->image && file_exists(public_path($popularClass->image))) {
            unlink(public_path($popularClass->image));
        }

        $popularClass->delete();
        return redirect()->route('backend.popularClasses.index')->with('success', 'Popular Classes deleted successfully.');
    }
}
