<?php

namespace App\Http\Controllers;

use App\Models\Section;
use Illuminate\Http\Request;

class SectionController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $sections = Section::latest()->paginate();
        return view('backend.sections.index',compact('sections'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('backend.sections.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'class' => 'required|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            'name' => 'nullable|string',
            'rank' => 'nullable|string'
        ]);

        $imagePath = null;
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $extension = $image->getClientOriginalExtension();
        $imageName = time() . '.' . $extension;
        $image->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName;
    }


    Section::create([
        'image' => $imagePath,
        'class' => $request->class,
        'name' => $request->name,
        'rank' => $request->rank,
        'status' => $request->status ? 1 : 0,
    ]);

    return redirect()->route('backend.sections.index')->with('success', 'Class 12 created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Section $section)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Section $section)
    {
        return view('backend.sections.edit',compact('section'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Section $section)
    {
         $request->validate([
            'class' => 'required|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            'name' => 'nullable|string',
            'rank' => 'nullable|string'
        ]);

        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($section->image && file_exists(public_path($section->image))) {
                unlink(public_path($section->image));
            }

            // Upload new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $section->image = 'admin/img/' . $imageName; // Save relative path
        }

        $section->update([
             'class' => $request->class,
        'name' => $request->name,
        'rank' => $request->rank,
            'status' => $request->status ? 1 : 0,
        ]);

        return redirect()->route('backend.sections.index')->with('success', 'Class 12 updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Section $section)
    {
         if ($section->image && file_exists(public_path($section->image))) {
            unlink(public_path($section->image));
        }

        $section->delete();
        return redirect()->route('backend.sections.index')->with('success', 'Class 12 deleted successfully.');
    }
}
