<?php

namespace App\Http\Controllers;

use App\Models\Menu;
use App\Models\Submenu;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SubmenuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
   public function index()
    {
        $submenus = Submenu::with('menu')->latest()->paginate(10);
        return view('backend.submenus.index', compact('submenus'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $menus=Menu::all();
        return view('backend.submenus.create',compact('menus'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'menu'=>'nullable|string',
            'title'=>'nullable|string',
            'url'=>'nullable|url',
            'metatitle'=>'nullable|string',
            'description'=>'nullable|string',
            'keywords'=>'nullable|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
        ]);

        $imagePath = null;
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $extension = $image->getClientOriginalExtension();
        $imageName = time() . '.' . $extension;
        $image->move(public_path('admin/img/'), $imageName);
        $imagePath = 'admin/img/' . $imageName;
    }

        Submenu::create([
            'menu_id' => $request->menu,
            'title' => $request->title,
            'slug' => Str::slug($request->title),
            'url' => $request->url,
            'image' => $imagePath,
            'metatitle' => $request->metatitle,
            'description' => $request->description,
            'keywords' => $request->keywords,
            'status' => $request->status ? 1 : 0,
        ]);
    
        return redirect()->route('backend.submenus.index')->with('success', 'Submenu created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Submenu $submenu)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Submenu $submenu)
    {
        $menus=Menu::all();
        return view('backend.submenus.edit',compact('menus','submenu'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Submenu $submenu)
    {
        $request->validate([
            'menu' => 'required|string',
            'title' => 'required|string|max:255',
            'url'=>'nullable|url',
            'metatitle'=>'nullable|string',
            'description'=>'nullable|string',
            'keywords'=>'nullable|string',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
        ]);
        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($submenu->image && file_exists(public_path($submenu->image))) {
                unlink(public_path($submenu->image));
            }

            // Upload new image
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('admin/img'), $imageName);
            $submenu->image = 'admin/img/' . $imageName; // Save relative path
        }

        $submenu->update([
            'menu_id' => $request->menu,
            'title' => $request->title,
            'slug' => Str::slug($request->title),
            'url' => $request->url,
            'metatitle' => $request->metatitle,
            'description' => $request->description,
            'keywords' => $request->keywords,
            'status' => $request->status ? 1 : 0,
        ]);

        return redirect()->route('backend.submenus.index')->with('success', 'Submenus updated successfully.');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Submenu $submenu)
    {
        if ($submenu->image && file_exists(public_path($submenu->image))) {
            unlink(public_path($submenu->image));
        }

        $submenu->delete();
        return redirect()->route('backend.submenus.index')->with('success', 'Submenu deleted successfully.');
    }
}
