<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\University;
use Illuminate\Http\Request;

class UniversityController extends Controller
{
    public function index()
    {
        $universities = University::all();
        return view('backend.universities.index', compact('universities'));
    }

    public function create()
    {
        return view('backend.universities.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'slug' => 'required|unique:universities',
        ]);

      // store()
            University::create([
                'name' => $request->name,
                'slug' => $request->slug,
                'description' => $request->description,
                'key_points' => array_filter($request->key_points),
            ]);


        return redirect()->route('backend.universities.index')->with('success', 'University created');
    }

    public function edit(University $university)
    {
        return view('backend.universities.edit', compact('university'));
    }

    public function update(Request $request, University $university)
    {
        $request->validate([
            'name' => 'required',
            'slug' => 'required|unique:universities,slug,' . $university->id,
        ]);

       // update()
            $university->update([
                'name' => $request->name,
                'slug' => $request->slug,
                'description' => $request->description,
                'key_points' => array_filter($request->key_points),
            ]);


        return redirect()->route('backend.universities.index')->with('success', 'Updated');
    }

    public function destroy(University $university)
    {
        $university->delete();
        return back()->with('success', 'Deleted');
    }
}
