<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Course extends Model
{
    use HasFactory;

    protected $table = 'courses';
    
    protected $fillable = [
        'university_id', 'title', 'cslug', 'deliverable', 'duration',
        'eligibility_criteria', 'subjects', 'image', 'popular', 'category_id',
    ];



    /**
     * The university this course belongs to.
     */
    public function university()
    {
        return $this->belongsTo(University::class);
    }

    // app/Models/Course.php
public function descriptions()
{
    return $this->hasMany(CourseDescription::class);
}

    public function category()
    {
        return $this->belongsTo(CourseCategory::class, 'category_id');
    }

}
