<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NewsCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
    ];

    // ✅ Add this relationship
    public function newsItems()
    {
        return $this->hasMany(NewsItem::class, 'news_category_id');
    }
}
