<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNoticesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('notices', function (Blueprint $table) {
    $table->id();
    $table->foreignId('notice_category_id')->constrained()->onDelete('cascade');
    $table->string('title');
    $table->date('date');
    $table->text('description');
    $table->string('pdf_path')->nullable();
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notices');
    }
}
